<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\Interest;
use Import\ApiBundle\Entity\PaymentAvg;
use Import\ApiBundle\Entity\PaymentMin;

/**
 * PaymentAvgRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PaymentAvgRepository extends EntityRepository
{
    /**
     * add new PaymentAvg
     *
     * @param $data
     * @param bool $flush
     * @return PaymentAvg
     */
    public function add($data, $flush = false)
    {
        $PaymentAvg = new PaymentAvg();

        $PaymentAvg->setValue($data['value']);
        $PaymentAvg->setMonth($data['month']);
        $PaymentAvg->setYear($data['year']);
        $PaymentAvg->setDescription($data['description']);

        $this->getEntityManager()->persist($PaymentAvg);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $PaymentAvg;
    }

    /**
     * get last PaymentAvg
     *
     * @return null|PaymentAvg
     */
    public function getLastAvgPayment()
    {
        $QueryBuilder = $this->createQueryBuilder('p');
        $QueryBuilder
            ->select('p')
            ->orderBy('p.year','DESC')
            ->addOrderBy('p.month','DESC')
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }

    /**
     * get last PaymentAvg
     *
     * @return null|PaymentAvg
     */
    public function getAvgPaymentForMonthAndYear($month,$year)
    {
        $QueryBuilder = $this->createQueryBuilder('p');
        $QueryBuilder
            ->select('p')
            ->where($QueryBuilder->expr()->eq('p.year',$year))
            ->andWhere($QueryBuilder->expr()->eq('p.month',$month))
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }
}
